/// @description follow the player
if (oGameController.state != gameState.paused and
	oGameController.state != gameState.waiting) {

	if (instance_exists(oPlayer)) {
		x = oPlayer.x;
		y = lerp(y, oPlayer.y+8, .6);
		image_xscale = oPlayer.image_xscale;

		// shoot the gun
		if (--shootTimer <= 0 && 
			oPlayer.shootKeyDown && 
			oPlayerStats.currentWeaponHeat < oPlayerStats.maxWeaponHeat - oPlayerStats.heatingSpeed
		) {
			shootTimer		= shootCooldown;
			kickbackOffset	= kickback;
			oPlayerStats.currentWeaponHeat += oPlayerStats.heatingSpeed;
			with (instance_create_layer(x + image_xscale*32, y, global.bulletsLayer, oPlayerBullet)) {
				image_xscale = other.image_xscale;
				if (other.image_xscale > 0) direction = dir.right;
				else direction = dir.left;
				damage = 1;
				knockback = 7;
			}
			audio_play_sound(oSoundManager.playerShoot, 1, false);
		}

		// Weapon cooling
		if (oPlayerStats.currentWeaponHeat > 0)
			oPlayerStats.currentWeaponHeat -= oPlayerStats.coolingSpeed;


		kickbackOffset = lerp(kickbackOffset, 0, .15);
		x += kickbackOffset * -image_xscale;
		
	} else {
		instance_destroy();
	}
}